-- Estructura inicial de la base de datos para gestor de stock
CREATE DATABASE IF NOT EXISTS gestor_stock;
USE gestor_stock;

CREATE TABLE ubicaciones (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nombre VARCHAR(100) NOT NULL
);

CREATE TABLE zonas (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nombre VARCHAR(100) NOT NULL,
    ubicacion_id INT,
    FOREIGN KEY (ubicacion_id) REFERENCES ubicaciones(id)
);

CREATE TABLE estados_dispositivo (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nombre VARCHAR(50) NOT NULL
);

CREATE TABLE equipos (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nombre VARCHAR(100) NOT NULL,
    estado_id INT,
    es_ot BOOLEAN,
    numero_serie VARCHAR(100),
    modelo VARCHAR(100),
    anydesk_id VARCHAR(50),
    procesador VARCHAR(100),
    ram VARCHAR(50),
    disco_duro VARCHAR(100),
    fecha_compra DATE,
    fecha_fin_garantia DATE,
    comentarios TEXT,
    zona_id INT,
    FOREIGN KEY (estado_id) REFERENCES estados_dispositivo(id),
    FOREIGN KEY (zona_id) REFERENCES zonas(id)
);

CREATE TABLE movimientos (
    id INT AUTO_INCREMENT PRIMARY KEY,
    equipo_id INT,
    ubicacion_id INT,
    zona_id INT,
    persona VARCHAR(100) NOT NULL,
    fecha_movimiento DATETIME,
    FOREIGN KEY (equipo_id) REFERENCES equipos(id),
    FOREIGN KEY (ubicacion_id) REFERENCES ubicaciones(id),
    FOREIGN KEY (zona_id) REFERENCES zonas(id)
);
