<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once __DIR__ . '/../src/db.php';

// --- FUNCIONES AUXILIARES ---
function buscarEquipoPorId($id) {
    global $pdo;
    $stmt = $pdo->prepare('SELECT * FROM equipos WHERE id = ?');
    $stmt->execute([$id]);
    return $stmt->fetch(PDO::FETCH_ASSOC);
}
function obtenerMovimientos($equipo_id) {
    global $pdo;
    $stmt = $pdo->prepare('SELECT m.*, u.nombre as ubicacion, z.nombre as zona FROM movimientos m
        LEFT JOIN ubicaciones u ON m.ubicacion_id = u.id
        LEFT JOIN zonas z ON m.zona_id = z.id
        WHERE m.equipo_id = ? ORDER BY m.fecha_movimiento DESC');
    $stmt->execute([$equipo_id]);
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

$pdo = getPDO();
$zonas = $pdo->query('SELECT z.*, u.nombre as ubicacion FROM zonas z LEFT JOIN ubicaciones u ON z.ubicacion_id = u.id')->fetchAll(PDO::FETCH_ASSOC);
$errorMsg = '';

// --- BUSQUEDA ---
$nombre = isset($_GET['nombre']) ? trim($_GET['nombre']) : '';
$equipos = [];

$equipos = [];
$filtro = isset($_GET['filtro']) ? $_GET['filtro'] : 'nombre';
$valor = isset($_GET['valor']) ? trim($_GET['valor']) : '';
if ($filtro === 'modelo' && $valor !== '') {
} elseif ($filtro === 'estado' && $valor !== '') {
    $stmt = $pdo->prepare('SELECT * FROM equipos WHERE estado_id = ?');
    $stmt->execute([$valor]);
    $equipos = $stmt->fetchAll(PDO::FETCH_ASSOC);
} elseif ($filtro === 'numero_serie' && $valor !== '') {
    $stmt = $pdo->prepare('SELECT * FROM equipos WHERE numero_serie LIKE ?');
    $stmt->execute(['%' . $valor . '%']);
    $equipos = $stmt->fetchAll(PDO::FETCH_ASSOC);
} elseif ($filtro === 'ot') {
    $stmt = $pdo->prepare('SELECT * FROM equipos WHERE es_ot = 1');
    $stmt->execute();
    $equipos = $stmt->fetchAll(PDO::FETCH_ASSOC);
} elseif ($filtro === 'procesador' && $valor !== '') {
    $stmt = $pdo->prepare('SELECT * FROM equipos WHERE procesador LIKE ?');
    $stmt->execute(['%' . $valor . '%']);
    $equipos = $stmt->fetchAll(PDO::FETCH_ASSOC);
} elseif ($filtro === 'ram' && $valor !== '') {
    $stmt = $pdo->prepare('SELECT * FROM equipos WHERE ram LIKE ?');
    $stmt->execute(['%' . $valor . '%']);
    $equipos = $stmt->fetchAll(PDO::FETCH_ASSOC);
} elseif ($filtro === 'disco' && $valor !== '') {
    $stmt = $pdo->prepare('SELECT * FROM equipos WHERE disco_duro LIKE ?');
    $stmt->execute(['%' . $valor . '%']);
    $equipos = $stmt->fetchAll(PDO::FETCH_ASSOC);
} elseif ($valor !== '') {
    $stmt = $pdo->prepare('SELECT * FROM equipos WHERE nombre LIKE ?');
    $stmt->execute(['%' . $valor . '%']);
    $equipos = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

$filtro = isset($_GET['filtro']) ? $_GET['filtro'] : 'nombre';

// --- ACTUALIZAR EQUIPO ---
// --- NUEVO MOVIMIENTO ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['nuevo_movimiento_equipo_id'])) {
    $equipo_id = $_POST['nuevo_movimiento_equipo_id'];
    $ubicacion_id = $_POST['ubicacion_id'];
    $zona_id = $_POST['zona_id'];
    $persona = trim($_POST['persona']);
    $fecha_movimiento = $_POST['fecha_movimiento'];
    if ($equipo_id && $ubicacion_id && $zona_id && $persona && $fecha_movimiento) {
        try {
            $stmt = $pdo->prepare('INSERT INTO movimientos (equipo_id, ubicacion_id, zona_id, persona, fecha_movimiento) VALUES (?, ?, ?, ?, ?)');
            $stmt->execute([$equipo_id, $ubicacion_id, $zona_id, $persona, $fecha_movimiento]);
            $mensaje = 'Movimiento registrado correctamente.';
        } catch (Exception $e) {
            $errorMsg = 'Error al guardar el movimiento: ' . $e->getMessage();
        }
    } else {
        $errorMsg = 'Todos los campos del movimiento son obligatorios.';
    }
}
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['edit_equipo_id'])) {
    $id = $_POST['edit_equipo_id'];
    $equipo_actual = buscarEquipoPorId($id);
    $nombre = array_key_exists('nombre', $_POST) ? $_POST['nombre'] : $equipo_actual['nombre'];
    $estado_id = array_key_exists('estado_id', $_POST) ? $_POST['estado_id'] : $equipo_actual['estado_id'];
    // Para OT, aceptar tanto string '1'/'0' como true/false
    if (array_key_exists('es_ot', $_POST)) {
        $es_ot = ($_POST['es_ot'] == '1' || $_POST['es_ot'] === 1 || $_POST['es_ot'] === true || $_POST['es_ot'] === 'Sí') ? 1 : 0;
    } else {
        $es_ot = $equipo_actual['es_ot'];
    }
    $numero_serie = array_key_exists('numero_serie', $_POST) ? $_POST['numero_serie'] : $equipo_actual['numero_serie'];
    $modelo = array_key_exists('modelo', $_POST) ? $_POST['modelo'] : $equipo_actual['modelo'];
    $anydesk_id = array_key_exists('anydesk_id', $_POST) ? $_POST['anydesk_id'] : $equipo_actual['anydesk_id'];
    $procesador = array_key_exists('procesador', $_POST) ? $_POST['procesador'] : $equipo_actual['procesador'];
    $ram = array_key_exists('ram', $_POST) ? $_POST['ram'] : $equipo_actual['ram'];
    $disco_duro = array_key_exists('disco_duro', $_POST) ? $_POST['disco_duro'] : $equipo_actual['disco_duro'];
    $fecha_compra = array_key_exists('fecha_compra', $_POST) ? $_POST['fecha_compra'] : $equipo_actual['fecha_compra'];
    $fecha_fin_garantia = array_key_exists('fecha_fin_garantia', $_POST) ? $_POST['fecha_fin_garantia'] : $equipo_actual['fecha_fin_garantia'];
    $comentarios = array_key_exists('comentarios', $_POST) ? $_POST['comentarios'] : $equipo_actual['comentarios'];
    $stmt = $pdo->prepare('UPDATE equipos SET nombre=?, estado_id=?, es_ot=?, numero_serie=?, modelo=?, anydesk_id=?, procesador=?, ram=?, disco_duro=?, fecha_compra=?, fecha_fin_garantia=?, comentarios=? WHERE id=?');
    $stmt->execute([$nombre, $estado_id, $es_ot, $numero_serie, $modelo, $anydesk_id, $procesador, $ram, $disco_duro, $fecha_compra, $fecha_fin_garantia, $comentarios, $id]);
    header('Location: index.php?nombre=' . urlencode($nombre));
    exit;
}

// --- HTML ---
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Gestor de Equipos</title>
    <link rel="stylesheet" href="style.css">
        <style>
        .form-buscar button[type="submit"] {
            padding: 8px 18px;
            border-radius: 5px;
            border: none;
            background: #0078d7;
            color: #fff;
            font-size: 1em;
            cursor: pointer;
            transition: background 0.2s;
            margin-left: 8px;
        }
                        <td colspan="4">
            background: #005fa3;
        }
        .form-buscar input[type="text"] {
            padding: 8px 12px;
            border-radius: 5px;
            border: 1px solid #bbb;
            font-size: 1em;
            background: #fafbfc;
            transition: border-color 0.2s;
            width: 220px;
            box-sizing: border-box;
        }
        .form-buscar input[type="text"]:focus {
            border-color: #0078d7;
            outline: none;
            background: #fff;
        }
        </style>
</head>
<body>
<nav style="width:100%;background:#0078d7;padding:0.7em 0 0.7em 0.5em;margin-bottom:1.5em;box-shadow:0 2px 8px #eee;display:flex;gap:1.5em;align-items:center;">
    <a href="crear_equipo.php" style="color:#fff;font-weight:500;text-decoration:none;font-size:1.1em;">➕ Añadir equipo</a>
    <a href="ubicaciones.php" style="color:#fff;font-weight:500;text-decoration:none;font-size:1.1em;">Ubicaciones</a>
    <a href="zonas.php" style="color:#fff;font-weight:500;text-decoration:none;font-size:1.1em;">Zonas</a>
    <a href="estados.php" style="color:#fff;font-weight:500;text-decoration:none;font-size:1.1em;">Estados</a>
</nav>
<div class="container-75">
    <?php if (!empty($mensaje)): ?>
        <div style="background:#d4edda;color:#155724;padding:1em 1.5em;margin-bottom:1em;border-radius:6px;border:1px solid #c3e6cb;">
            <?= htmlspecialchars($mensaje) ?>
        </div>
    <?php endif; ?>
    <?php if (!empty($errorMsg)): ?>
        <div style="background:#f8d7da;color:#721c24;padding:1em 1.5em;margin-bottom:1em;border-radius:6px;border:1px solid #f5c6cb;">
            <?= htmlspecialchars($errorMsg) ?>
        </div>
    <?php endif; ?>
    <h1>Gestor de Equipos</h1>
    <form method="get" style="margin-bottom:1em; display: flex; gap: 8px; align-items: center;" id="form-busqueda">
        <select name="filtro" id="filtro-select" style="padding:8px 12px; border-radius:5px; border:1px solid #bbb; font-size:1em;">
            <option value="estado" <?= isset($_GET['filtro']) && $_GET['filtro']==='estado' ? 'selected' : '' ?>>Estado</option>
            <option value="nombre" <?= isset($_GET['filtro']) && $_GET['filtro']==='nombre' ? 'selected' : '' ?>>Nombre</option>
            <option value="modelo" <?= isset($_GET['filtro']) && $_GET['filtro']==='modelo' ? 'selected' : '' ?>>Modelo</option>
            <option value="numero_serie" <?= isset($_GET['filtro']) && $_GET['filtro']==='numero_serie' ? 'selected' : '' ?>>N° Serie</option>
            <option value="ot" <?= isset($_GET['filtro']) && $_GET['filtro']==='ot' ? 'selected' : '' ?>>OT</option>
            <option value="procesador" <?= isset($_GET['filtro']) && $_GET['filtro']==='procesador' ? 'selected' : '' ?>>CPU</option>
            <option value="ram" <?= isset($_GET['filtro']) && $_GET['filtro']==='ram' ? 'selected' : '' ?>>RAM</option>
            <option value="disco" <?= isset($_GET['filtro']) && $_GET['filtro']==='disco' ? 'selected' : '' ?>>Disco</option>
        </select>
    <span id="input-valor-span"></span>
        <button type="submit" class="form-buscar">Buscar</button>
    <a id="btn-exportar-excel" href="#" style="padding:8px 18px;border-radius:5px;background:#28a745;color:#fff;text-decoration:none;font-size:1em;margin-left:8px;">Exportar a Excel</a>
    </form>
    <script>
    // Botón exportar a excel
    document.addEventListener('DOMContentLoaded', function() {
        var btnExportar = document.getElementById('btn-exportar-excel');
        if (btnExportar) {
            btnExportar.addEventListener('click', function(e) {
                e.preventDefault();
                var filtro = document.getElementById('filtro-select').value;
                var valor = '';
                var input = document.getElementById('input-valor');
                if (input) valor = input.value;
                var url = 'exportar_excel.php?filtro=' + encodeURIComponent(filtro) + '&valor=' + encodeURIComponent(valor);
                window.location.href = url;
            });
        }
    });
    document.addEventListener('DOMContentLoaded', function() {
        function toggleInput() {
            var filtro = document.getElementById('filtro-select').value;
            var input = document.getElementById('input-valor');
            var inputSpan = document.getElementById('input-valor-span');
            if (filtro === 'estado') {
                fetch('estados_api.php')
                  .then(r => r.json())
                  .then(estados => {
                    var select = document.createElement('select');
                    select.name = 'valor';
                    select.id = 'input-valor';
                    select.style.padding = '8px 12px';
                    select.style.borderRadius = '5px';
                    select.style.border = '1px solid #bbb';
                    select.style.fontSize = '1em';
                    var opt = document.createElement('option');
                    opt.value = '';
                    opt.textContent = 'Seleccione estado';
                    select.appendChild(opt);
                    estados.forEach(function(e) {
                        var o = document.createElement('option');
                        o.value = e.id;
                        o.textContent = e.nombre;
                        if ('<?= isset($_GET['valor']) ? $_GET['valor'] : '' ?>' == e.id) o.selected = true;
                        select.appendChild(o);
                    });
                    inputSpan.innerHTML = '';
                    inputSpan.appendChild(select);
                  });
                if (input) input.style.display = 'none';
            } else if (filtro === 'ot') {
                if (input) input.style.display = 'none';
                if (input) input.value = '';
                inputSpan.innerHTML = '';
            } else {
                inputSpan.innerHTML = '<input type="text" name="valor" id="input-valor" placeholder="Valor a buscar" value="<?= isset($_GET['valor']) ? htmlspecialchars($_GET['valor']) : '' ?>">';
            }
        }
        document.getElementById('filtro-select').addEventListener('change', toggleInput);
        toggleInput();
    });
    </script>

    <?php if ((isset($_GET['filtro']) && $_GET['filtro'] === 'ot') || (isset($_GET['valor']) && trim($_GET['valor']) !== '')): ?>
        <?php if (count($equipos) > 0): ?>
            <table style="width:100%;border-collapse:collapse;margin-bottom:1.5em;">
                <thead>
                    <tr style="background:#f0f0f0;">
                        <th style="padding:8px 12px;border:1px solid #ccc;">Equipo</th>
                        <th style="padding:8px 12px;border:1px solid #ccc;">Persona</th>
                        <th style="padding:8px 12px;border:1px solid #ccc;">Ubicación</th>
                        <th style="padding:8px 12px;border:1px solid #ccc;">Estado</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($equipos as $equipo): ?>
                    <?php 
                        $movs = obtenerMovimientos($equipo['id']);
                        $persona = '';
                        $ubicacion = '';
                        $zona = '';
                        if (count($movs) > 0) {
                            foreach ($movs as $mov) {
                                if (!empty($mov['persona'])) {
                                    $persona = $mov['persona'];
                                    $ubicacion = $mov['ubicacion'];
                                    $zona = $mov['zona'];
                                    break;
                                }
                            }
                            // Si no hay persona, igual mostramos la última ubicación y zona
                            if ($persona === '') {
                                $ubicacion = $movs[0]['ubicacion'];
                                $zona = $movs[0]['zona'];
                            }
                        }
                    ?>
                    <tr>
                        <td style="padding:8px 12px;border:1px solid #ccc;">
                            <a href="#" class="ver-detalle-equipo" data-equipo-id="<?= $equipo['id'] ?>" style="color:#0078d7;text-decoration:underline;cursor:pointer;">
                                <?= htmlspecialchars($equipo['nombre']) ?>
                            </a>
                        </td>
                        <td style="padding:8px 12px;border:1px solid #ccc;">
                            <?= htmlspecialchars($persona) ?>
                        </td>
                        <td style="padding:8px 12px;border:1px solid #ccc;">
                            <?= htmlspecialchars($ubicacion) ?>
                        </td>
                        <td style="padding:8px 12px;border:1px solid #ccc;">
                            <?php
                                $estados = $pdo->query('SELECT * FROM estados_dispositivo')->fetchAll(PDO::FETCH_ASSOC);
                                $nombre_estado = '';
                                foreach ($estados as $estado) {
                                    if ($estado['id'] == $equipo['estado_id']) {
                                        $nombre_estado = $estado['nombre'];
                                        break;
                                    }
                                }
                                echo htmlspecialchars($nombre_estado);
                            ?>
                        </td>
                    </tr>
                    <tr id="detalle-equipo-<?= $equipo['id'] ?>" style="display:none;background:#f9f9f9;">
                        <td colspan="4">
                            <div style="padding:1em;">
                                <table style="width:100%; border-collapse:collapse;">
                                    <tr>
                                        <td style="padding:2px 8px;"><b>Estado:</b></td>
                                        <td style="padding:2px 8px;">
                                            <?php
                                                $estados = $pdo->query('SELECT * FROM estados_dispositivo')->fetchAll(PDO::FETCH_ASSOC);
                                                foreach ($estados as $estado) {
                                                    if ($estado['id'] == $equipo['estado_id']) {
                                                        echo htmlspecialchars($estado['nombre']);
                                                        break;
                                                    }
                                                }
                                            ?>
                                        </td>
                                        <td style="padding:2px 8px;"><b>OT:</b></td>
                                        <td style="padding:2px 8px;"><?= $equipo['es_ot'] ? 'Sí' : 'No' ?></td>
                                    </tr>
                                    <tr>
                                        <td style="padding:2px 8px;"><b>ID AnyDesk:</b></td>
                                        <td colspan="3" style="padding:2px 8px;"><?= htmlspecialchars($equipo['anydesk_id']) ?></td>
                                    </tr>
                                    <tr>
                                        <td style="padding:2px 8px;"><b>Número de serie:</b></td>
                                        <td style="padding:2px 8px;"><?= htmlspecialchars($equipo['numero_serie']) ?></td>
                                        <td style="padding:2px 8px;"><b>Modelo:</b></td>
                                        <td style="padding:2px 8px;"><?= htmlspecialchars($equipo['modelo']) ?></td>
                                    </tr>
                                    <tr>
                                        <td style="padding:2px 8px;"><b>Procesador:</b></td>
                                        <td style="padding:2px 8px;"><?= htmlspecialchars($equipo['procesador']) ?></td>
                                        <td style="padding:2px 8px;"><b>RAM:</b></td>
                                        <td style="padding:2px 8px;"><?= htmlspecialchars($equipo['ram']) ?></td>
                                    </tr>
                                    <tr>
                                        <td style="padding:2px 8px;"><b>Disco duro:</b></td>
                                        <td style="padding:2px 8px;"><?= htmlspecialchars($equipo['disco_duro']) ?></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td style="padding:2px 8px;"><b>Fecha de compra:</b></td>
                                        <td style="padding:2px 8px;"><?= htmlspecialchars($equipo['fecha_compra']) ?></td>
                                        <td style="padding:2px 8px;"><b>Fin de garantía:</b></td>
                                        <td style="padding:2px 8px;"><?= htmlspecialchars($equipo['fecha_fin_garantia']) ?></td>
                                    </tr>
                                    <tr>
                                        <td style="padding:2px 8px;"><b>Comentarios:</b></td>
                                        <td colspan="3" style="padding:2px 8px;"><?= nl2br(htmlspecialchars($equipo['comentarios'])) ?></td>
                                    </tr>
                                </table>
                                <h4 style="margin-top:1.5em;">Movimientos</h4>
                                <table class="tabla-movimientos" style="width:100%;border-collapse:collapse;margin-bottom:1em;">
                                    <thead>
                                        <tr style="background:#f0f0f0;">
                                            <th style="padding:4px 8px;border:1px solid #ccc;">Fecha</th>
                                            <th style="padding:4px 8px;border:1px solid #ccc;">Ubicación</th>
                                            <th style="padding:4px 8px;border:1px solid #ccc;">Zona</th>
                                            <th style="padding:4px 8px;border:1px solid #ccc;">Persona</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    <?php foreach ($movs as $mov): ?>
                                        <tr>
                                            <td style="padding:4px 8px;border:1px solid #ccc;white-space:nowrap;">
                                                <?= htmlspecialchars(date('d/m/Y H:i', strtotime($mov['fecha_movimiento']))) ?>
                                            </td>
                                            <td style="padding:4px 8px;border:1px solid #ccc;">
                                                <?= htmlspecialchars($mov['ubicacion']) ?>
                                            </td>
                                            <td style="padding:4px 8px;border:1px solid #ccc;">
                                                <?= htmlspecialchars($mov['zona']) ?>
                                            </td>
                                            <td style="padding:4px 8px;border:1px solid #ccc;">
                                                <?= htmlspecialchars($mov['persona']) ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                    </tbody>
                                </table>
                                <div style="text-align:center; margin: 1em 0;">
                                    <button type="button" class="btn-nuevo-movimiento" data-equipo-id="<?= $equipo['id'] ?>">Nuevo movimiento</button>
                                </div>
                                <!-- Modal de nuevo movimiento -->
                                <div class="modal-nuevo-movimiento" id="modal-movimiento-<?= $equipo['id'] ?>" style="display:none; position:fixed; top:0; left:0; width:100vw; height:100vh; background:rgba(0,0,0,0.4); z-index:1000; align-items:center; justify-content:center;">
                                    <div style="background:#fff; padding:2em; border-radius:10px; max-width:400px; margin:auto; position:relative;">
                                        <button type="button" class="cerrar-modal-mov" style="position:absolute; top:10px; right:10px; font-size:1.2em; background:none; border:none; cursor:pointer;">&times;</button>
                                        <form method="post">
                                            <input type="hidden" name="nuevo_movimiento_equipo_id" value="<?= $equipo['id'] ?>">
                                            <label>Ubicación:
                                                <select name="ubicacion_id" required>
                                                    <?php $ubicaciones = $pdo->query('SELECT * FROM ubicaciones')->fetchAll(PDO::FETCH_ASSOC); foreach ($ubicaciones as $u): ?>
                                                        <option value="<?= $u['id'] ?>"><?= htmlspecialchars($u['nombre']) ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </label><br>
                                            <label>Zona:
                                                <select name="zona_id" required>
                                                    <?php foreach ($zonas as $zona): ?>
                                                        <option value="<?= $zona['id'] ?>"><?= htmlspecialchars($zona['nombre']) ?> (<?= htmlspecialchars($zona['ubicacion']) ?>)</option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </label><br>
                                            <label>Persona:<input type="text" name="persona" required></label><br>
                                            <label>Fecha movimiento: <input type="datetime-local" name="fecha_movimiento" required></label><br>
                                            <button type="submit">Registrar movimiento</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
            <script>
            document.querySelectorAll('.ver-detalle-equipo').forEach(function(link) {
                link.addEventListener('click', function(e) {
                    e.preventDefault();
                    var id = link.getAttribute('data-equipo-id');
                    var detalle = document.getElementById('detalle-equipo-' + id);
                    if (detalle.style.display === 'none' || detalle.style.display === '') {
                        detalle.style.display = 'table-row';
                    } else {
                        detalle.style.display = 'none';
                    }
                });
            });
            </script>
        <?php endif; ?>
        <?php endif; ?>

<style>
.modal-editar-equipo { display:none; position:fixed; top:0; left:0; width:100vw; height:100vh; background:rgba(0,0,0,0.4); z-index:1000; align-items:center; justify-content:center; }
.modal-editar-equipo[style*="display: flex"] { display: flex !important; }
.modal-nuevo-movimiento { display:none; position:fixed; top:0; left:0; width:100vw; height:100vh; background:rgba(0,0,0,0.4); z-index:1000; align-items:center; justify-content:center; }
.modal-nuevo-movimiento[style*="display: flex"] { display: flex !important; }

/* Responsive modal content */
.modal-editar-equipo > div,
.modal-nuevo-movimiento > div {
    width: 95vw;
    max-width: 400px;
    box-sizing: border-box;
    max-height: 90vh;
    overflow-y: auto;
}

/* Estilo para los campos de los modal box */
.modal-editar-equipo form input[type="text"],
.modal-editar-equipo form input[type="date"],
.modal-editar-equipo form input[type="datetime-local"],
.modal-editar-equipo form select,
.modal-editar-equipo form textarea,
.modal-nuevo-movimiento form input[type="text"],
.modal-nuevo-movimiento form input[type="date"],
.modal-nuevo-movimiento form input[type="datetime-local"],
.modal-nuevo-movimiento form select,
.modal-nuevo-movimiento form textarea {
    width: 100%;
    padding: 7px 10px;
    margin: 6px 0 14px 0;
    border: 1px solid #bbb;
    border-radius: 5px;
    font-size: 1em;
    box-sizing: border-box;
    background: #fafbfc;
    transition: border-color 0.2s;
}
.modal-editar-equipo form input[type="text"]:focus,
.modal-editar-equipo form input[type="date"]:focus,
.modal-editar-equipo form input[type="datetime-local"]:focus,
.modal-editar-equipo form select:focus,
.modal-editar-equipo form textarea:focus,
.modal-nuevo-movimiento form input[type="text"]:focus,
.modal-nuevo-movimiento form input[type="date"]:focus,
.modal-nuevo-movimiento form input[type="datetime-local"]:focus,
.modal-nuevo-movimiento form select:focus,
.modal-nuevo-movimiento form textarea:focus {
    border-color: #0078d7;
    outline: none;
    background: #fff;
}
.modal-editar-equipo form label,
.modal-nuevo-movimiento form label {
    display: block;
    margin-bottom: 2px;
    font-weight: 500;
}
.modal-editar-equipo form button,
.modal-nuevo-movimiento form button {
    margin-top: 10px;
    padding: 8px 18px;
    border-radius: 5px;
    border: none;
    background: #0078d7;
    color: #fff;
    font-size: 1em;
    cursor: pointer;
    transition: background 0.2s;
}
.modal-editar-equipo form button:hover,
.modal-nuevo-movimiento form button:hover {
    background: #005fa3;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Modal edición equipo
    document.querySelectorAll('.btn-editar-equipo').forEach(function(btn) {
        btn.addEventListener('click', function() {
            var id = btn.getAttribute('data-equipo-id');
            var modal = document.getElementById('modal-editar-' + id);
            if (modal) modal.style.display = 'flex';
        });
    });
    document.querySelectorAll('.cerrar-modal').forEach(function(btn) {
        btn.addEventListener('click', function() {
            btn.closest('.modal-editar-equipo').style.display = 'none';
        });
    });
    // Cerrar modal al hacer click fuera del contenido
    document.querySelectorAll('.modal-editar-equipo').forEach(function(modal) {
        modal.addEventListener('click', function(e) {
            if (e.target === modal) modal.style.display = 'none';
        });
    });

    // Modal nuevo movimiento
    document.querySelectorAll('.btn-nuevo-movimiento').forEach(function(btn) {
        btn.addEventListener('click', function() {
            var id = btn.getAttribute('data-equipo-id');
            var modal = document.getElementById('modal-movimiento-' + id);
            if (modal) modal.style.display = 'flex';
        });
    });
    document.querySelectorAll('.cerrar-modal-mov').forEach(function(btn) {
        btn.addEventListener('click', function() {
            btn.closest('.modal-nuevo-movimiento').style.display = 'none';
        });
    });
    // Cerrar modal al hacer click fuera del contenido
    document.querySelectorAll('.modal-nuevo-movimiento').forEach(function(modal) {
        modal.addEventListener('click', function(e) {
            if (e.target === modal) modal.style.display = 'none';
        });
    });
});
</script>

                    <!-- Modal de edición de equipo -->
                    <div class="modal-editar-equipo" id="modal-editar-<?= $equipo['id'] ?>" style="display:none; position:fixed; top:0; left:0; width:100vw; height:100vh; background:rgba(0,0,0,0.4); z-index:1000; align-items:center; justify-content:center;">
                        <div style="background:#fff; padding:2em; border-radius:10px; max-width:400px; margin:auto; position:relative;">
                            <button type="button" class="cerrar-modal" style="position:absolute; top:10px; right:10px; font-size:1.2em; background:none; border:none; cursor:pointer;">&times;</button>
                            <form method="post">
                                <input type="hidden" name="edit_equipo_id" value="<?= $equipo['id'] ?>">
                                <label>Nombre: <input type="text" name="nombre" value="<?= htmlspecialchars($equipo['nombre']) ?>" required></label><br>
                                <label>Estado:
                                    <select name="estado_id" required>
                                        <?php foreach ($estados as $estado): ?>
                                            <option value="<?= $estado['id'] ?>" <?= $equipo['estado_id'] == $estado['id'] ? 'selected' : '' ?>><?= htmlspecialchars($estado['nombre']) ?></option>
                                        <?php endforeach; ?>
                                    </select>
                                </label><br>
                                <label>OT: <input type="checkbox" name="es_ot" value="1" <?= $equipo['es_ot'] ? 'checked' : '' ?>></label><br>
                                <label>Número de serie: <input type="text" name="numero_serie" value="<?= htmlspecialchars($equipo['numero_serie']) ?>"></label><br>
                                <label>Modelo: <input type="text" name="modelo" value="<?= htmlspecialchars($equipo['modelo']) ?>"></label><br>
                                <label>ID AnyDesk: <input type="text" name="anydesk_id" value="<?= htmlspecialchars($equipo['anydesk_id']) ?>"></label><br>
                                <label>Procesador: <input type="text" name="procesador" value="<?= htmlspecialchars($equipo['procesador']) ?>"></label><br>
                                <label>RAM: <input type="text" name="ram" value="<?= htmlspecialchars($equipo['ram']) ?>"></label><br>
                                <label>Disco duro: <input type="text" name="disco_duro" value="<?= htmlspecialchars($equipo['disco_duro']) ?>"></label><br>
                                <label>Fecha de compra: <input type="date" name="fecha_compra" value="<?= htmlspecialchars($equipo['fecha_compra']) ?>"></label><br>
                                <label>Fin de garantía: <input type="date" name="fecha_fin_garantia" value="<?= htmlspecialchars($equipo['fecha_fin_garantia']) ?>"></label><br>
                                <label>Comentarios:<br><textarea name="comentarios" rows="2" cols="40"><?= htmlspecialchars($equipo['comentarios']) ?></textarea></label><br>
                                <button type="submit">Guardar cambios</button>
                            </form>
                        </div>
                    </div>

        </div>
</div>
</body>
</html>
    </div>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Edición en línea de celdas
    document.querySelectorAll('.editable-table').forEach(function(table) {
        table.addEventListener('click', function(e) {
            const cell = e.target.closest('.editable-cell');
            if (!cell || cell.querySelector('input, select, textarea')) return;
            const type = cell.dataset.type;
            const field = cell.dataset.field;
            let value = cell.dataset.value !== undefined ? cell.dataset.value : cell.textContent.trim();
            let input;
            if (type === 'select') {
                input = document.createElement('select');
                <?php $estados = $pdo->query('SELECT * FROM estados_dispositivo')->fetchAll(PDO::FETCH_ASSOC); ?>
                <?php foreach ($estados as $estado): ?>
                    let opt<?= $estado['id'] ?> = document.createElement('option');
                    opt<?= $estado['id'] ?>.value = "<?= $estado['id'] ?>";
                    opt<?= $estado['id'] ?>.textContent = "<?= htmlspecialchars($estado['nombre']) ?>";
                    if (value == "<?= $estado['id'] ?>") opt<?= $estado['id'] ?>.selected = true;
                    input.appendChild(opt<?= $estado['id'] ?>);
                <?php endforeach; ?>
            } else if (type === 'checkbox') {
                input = document.createElement('input');
                input.type = 'checkbox';
                input.checked = value == '1' || value === true || value === 'Sí';
            } else if (type === 'date') {
                input = document.createElement('input');
                input.type = 'date';
                input.value = value;
            } else if (type === 'textarea') {
                input = document.createElement('textarea');
                input.value = cell.innerText.trim();
            } else {
                input = document.createElement('input');
                input.type = 'text';
                input.value = value;
            }
            input.style.width = '95%';
            cell.innerHTML = '';
            cell.appendChild(input);
            input.focus();
            input.addEventListener('blur', function() {
                let newValue;
                if (type === 'checkbox') {
                    newValue = input.checked ? '1' : '0';
                    cell.textContent = input.checked ? 'Sí' : 'No';
                } else if (type === 'select') {
                    newValue = input.value;
                    cell.textContent = input.options[input.selectedIndex].textContent;
                } else {
                    newValue = input.value;
                    cell.textContent = newValue;
                }
                cell.dataset.value = newValue;
                cell.classList.add('edited');
                // Mostrar botón guardar
                const form = cell.closest('form');
                if (form) form.querySelector('.btn-guardar-cambios').classList.add('show');
            });
            if (type !== 'textarea') input.addEventListener('keydown', function(ev) {
                if (ev.key === 'Enter') {
                    ev.preventDefault();
                    input.blur();
                }
            });
        });
    });
    // Al guardar, poner los valores actuales de todas las celdas en inputs ocultos
    document.querySelectorAll('.form-inline-edit').forEach(function(form) {
        form.addEventListener('submit', function(e) {
            // Eliminar todos los inputs previos excepto edit_equipo_id
            form.querySelectorAll('input[type=hidden]').forEach(function(h) {
                if (h.name !== 'edit_equipo_id') h.remove();
            });
            form.querySelectorAll('.editable-cell').forEach(function(cell) {
                let input = document.createElement('input');
                input.type = 'hidden';
                input.name = cell.dataset.field;
                // Para el checkbox OT, siempre enviar '1' o '0'
                if (cell.dataset.field === 'es_ot') {
                    let v = cell.dataset.value;
                    if (v === undefined) v = cell.textContent.trim();
                    input.value = (v == '1' || v === 'Sí') ? '1' : '0';
                } else {
                    input.value = cell.dataset.value !== undefined ? cell.dataset.value : cell.textContent.trim();
                }
                form.appendChild(input);
            });
        });
    });
});

</script>
</body>
</html>