<?php
require_once __DIR__ . '/../src/db.php';
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment; filename="equipos_exportados.xls"');

$pdo = getPDO();
$filtro = isset($_GET['filtro']) ? $_GET['filtro'] : 'nombre';
$valor = isset($_GET['valor']) ? trim($_GET['valor']) : '';

$query = 'SELECT * FROM equipos';
$params = [];
if ($filtro === 'modelo' && $valor !== '') {
    $query .= ' WHERE modelo LIKE ?';
    $params[] = "%$valor%";
} elseif ($filtro === 'numero_serie' && $valor !== '') {
    $query .= ' WHERE numero_serie LIKE ?';
    $params[] = "%$valor%";
} elseif ($filtro === 'ot') {
    $query .= ' WHERE es_ot = 1';
} elseif ($filtro === 'procesador' && $valor !== '') {
    $query .= ' WHERE procesador LIKE ?';
    $params[] = "%$valor%";
} elseif ($filtro === 'ram' && $valor !== '') {
    $query .= ' WHERE ram LIKE ?';
    $params[] = "%$valor%";
} elseif ($filtro === 'disco' && $valor !== '') {
    $query .= ' WHERE disco_duro LIKE ?';
    $params[] = "%$valor%";
} elseif ($filtro === 'estado' && $valor !== '') {
    $query .= ' WHERE estado_id = ?';
    $params[] = $valor;
} elseif ($valor !== '') {
    $query .= ' WHERE nombre LIKE ?';
    $params[] = "%$valor%";
}
$stmt = $pdo->prepare($query);
$stmt->execute($params);
$equipos = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Obtener estados
$estados = $pdo->query('SELECT * FROM estados_dispositivo')->fetchAll(PDO::FETCH_ASSOC);
$estados_map = [];
foreach ($estados as $estado) {
    $estados_map[$estado['id']] = $estado['nombre'];
}

echo "<table border='1'>";
echo "<tr>
<th>Equipo</th>
<th>Estado</th>
<th>OT</th>
<th>ID AnyDesk</th>
<th>Número de serie</th>
<th>Modelo</th>
<th>Procesador</th>
<th>RAM</th>
<th>Disco duro</th>
<th>Fecha de compra</th>
<th>Fin de garantía</th>
<th>Comentarios</th>
<th>Movimientos</th>
</tr>";
foreach ($equipos as $equipo) {
    $estado = isset($estados_map[$equipo['estado_id']]) ? $estados_map[$equipo['estado_id']] : '';
    $ot = $equipo['es_ot'] ? 'Sí' : 'No';
    $anydesk = $equipo['anydesk_id'];
    $num_serie = $equipo['numero_serie'];
    $modelo = $equipo['modelo'];
    $procesador = $equipo['procesador'];
    $ram = $equipo['ram'];
    $disco = $equipo['disco_duro'];
    $fcompra = $equipo['fecha_compra'];
    $fgarantia = $equipo['fecha_fin_garantia'];
    $coment = $equipo['comentarios'];
    // Movimientos
    $stmt2 = $pdo->prepare('SELECT m.*, u.nombre as ubicacion, z.nombre as zona FROM movimientos m LEFT JOIN ubicaciones u ON m.ubicacion_id = u.id LEFT JOIN zonas z ON m.zona_id = z.id WHERE m.equipo_id = ? ORDER BY m.fecha_movimiento DESC');
    $stmt2->execute([$equipo['id']]);
    $movs = $stmt2->fetchAll(PDO::FETCH_ASSOC);
    $movs_str = '';
    foreach ($movs as $mov) {
        $movs_str .= 'Fecha: ' . $mov['fecha_movimiento'] . ' | Ubicación: ' . $mov['ubicacion'] . ' | Zona: ' . $mov['zona'] . ' | Persona: ' . $mov['persona'] . "\n";
    }
    echo "<tr>";
    echo "<td>" . htmlspecialchars($equipo['nombre']) . "</td>";
    echo "<td>" . htmlspecialchars($estado) . "</td>";
    echo "<td>" . htmlspecialchars($ot) . "</td>";
    echo "<td>" . htmlspecialchars($anydesk) . "</td>";
    echo "<td>" . htmlspecialchars($num_serie) . "</td>";
    echo "<td>" . htmlspecialchars($modelo) . "</td>";
    echo "<td>" . htmlspecialchars($procesador) . "</td>";
    echo "<td>" . htmlspecialchars($ram) . "</td>";
    echo "<td>" . htmlspecialchars($disco) . "</td>";
    echo "<td>" . htmlspecialchars($fcompra) . "</td>";
    echo "<td>" . htmlspecialchars($fgarantia) . "</td>";
    echo "<td>" . nl2br(htmlspecialchars($coment)) . "</td>";
    echo "<td>" . nl2br(htmlspecialchars($movs_str)) . "</td>";
    echo "</tr>";
}
echo "</table>";
