<?php
require_once __DIR__ . '/../src/db.php';
$errorMsg = '';
$pdo = null;

try {
    $pdo = getPDO();
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $nombre = $_POST['nombre'] ?? '';
        $estado_id = $_POST['estado_id'] ?? '';
        $es_ot = isset($_POST['es_ot']) ? 1 : 0;
        $numero_serie = $_POST['numero_serie'] ?? '';
        $modelo = $_POST['modelo'] ?? '';
        $anydesk_id = $_POST['anydesk_id'] ?? '';
        $procesador = $_POST['procesador'] ?? '';
        $ram = $_POST['ram'] ?? '';
        $disco_duro = $_POST['disco_duro'] ?? '';
        $fecha_compra = $_POST['fecha_compra'] ?? null;
        $fecha_fin_garantia = $_POST['fecha_fin_garantia'] ?? null;
    $comentarios = $_POST['comentarios'] ?? '';
    $stmt = $pdo->prepare('INSERT INTO equipos (nombre, estado_id, es_ot, numero_serie, modelo, anydesk_id, procesador, ram, disco_duro, fecha_compra, fecha_fin_garantia, comentarios) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)');
    $ok = $stmt->execute([$nombre, $estado_id, $es_ot, $numero_serie, $modelo, $anydesk_id, $procesador, $ram, $disco_duro, $fecha_compra, $fecha_fin_garantia, $comentarios]);
        if (!$ok || $stmt->rowCount() === 0) {
            $errorMsg = 'No se pudo crear el equipo. Verifica los datos ingresados y que existan zona y estado válidos.';
        } else {
            header('Location: index.php?nombre=' . urlencode($nombre));
            exit;
        }
    }
    $estados = $pdo->query('SELECT * FROM estados_dispositivo')->fetchAll(PDO::FETCH_ASSOC);
    // $zonas = $pdo->query('SELECT z.*, u.nombre as ubicacion FROM zonas z LEFT JOIN ubicaciones u ON z.ubicacion_id = u.id')->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    $errorMsg = $e->getMessage();
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Crear Equipo</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <nav style="width:100%;background:#0078d7;padding:0.7em 0 0.7em 0.5em;margin-bottom:1.5em;box-shadow:0 2px 8px #eee;display:flex;gap:1.5em;align-items:center;">
        <a href="index.php" style="color:#fff;font-weight:500;text-decoration:none;font-size:1.1em;">Equipos</a>
        <a href="crear_equipo.php" style="color:#fff;font-weight:500;text-decoration:none;font-size:1.1em;">Añadir equipo</a>
        <a href="ubicaciones.php" style="color:#fff;font-weight:500;text-decoration:none;font-size:1.1em;">Ubicaciones</a>
        <a href="zonas.php" style="color:#fff;font-weight:500;text-decoration:none;font-size:1.1em;">Zonas</a>
        <a href="estados.php" style="color:#fff;font-weight:500;text-decoration:none;font-size:1.1em;">Estados</a>
    </nav>
    <div class="container">
        <h1>Crear nuevo equipo</h1>
        <?php if (!empty($errorMsg)): ?>
            <div class="alert-error">
                <b>Error:</b> <?= htmlspecialchars($errorMsg) ?>
            </div>
        <?php endif; ?>
        <form method="post" class="form-equipo">
            <div class="form-row">
                <label for="nombre">Nombre:</label>
                <input type="text" name="nombre" id="nombre" required>
            </div>
            <div class="form-row">
                <label for="estado_id">Estado:</label>
                <select name="estado_id" id="estado_id" required>
                    <option value="">Selecciona estado</option>
                    <?php foreach ($estados as $estado): ?>
                        <option value="<?= $estado['id'] ?>"><?= htmlspecialchars($estado['nombre']) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="form-row">
                <label for="es_ot">OT:</label>
                <input type="checkbox" name="es_ot" id="es_ot" value="1">
            </div>
            <div class="form-row">
                <label for="numero_serie">Número de serie:</label>
                <input type="text" name="numero_serie" id="numero_serie">
            </div>
            <div class="form-row">
                <label for="modelo">Modelo:</label>
                <input type="text" name="modelo" id="modelo">
            </div>
            <div class="form-row">
                <label for="anydesk_id">ID AnyDesk:</label>
                <input type="text" name="anydesk_id" id="anydesk_id">
            </div>
            <div class="form-row">
                <label for="procesador">Procesador:</label>
                <input type="text" name="procesador" id="procesador">
            </div>
            <div class="form-row">
                <label for="ram">RAM:</label>
                <input type="text" name="ram" id="ram">
            </div>
            <div class="form-row">
                <label for="disco_duro">Disco duro:</label>
                <input type="text" name="disco_duro" id="disco_duro">
            </div>
            <div class="form-row">
                <label for="fecha_compra">Fecha de compra:</label>
                <input type="date" name="fecha_compra" id="fecha_compra">
            </div>
            <div class="form-row">
                <label for="fecha_fin_garantia">Fin de garantía:</label>
                <input type="date" name="fecha_fin_garantia" id="fecha_fin_garantia">
            </div>
            <!-- Zona eliminada del formulario -->
            <div class="form-row">
                <label for="comentarios">Comentarios:</label>
                <textarea name="comentarios" id="comentarios" rows="2" cols="40"></textarea>
            </div>
            <div class="form-row form-actions">
                <button type="submit">Crear equipo</button>
                <a href="index.php" class="btn-link">Volver al listado</a>
            </div>
        </form>
    </div>
</body>
</html>
